"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCookieExpiryTimeMS = getCookieExpiryTimeMS;
exports.getCookieExpiryTimeS = getCookieExpiryTimeS;
exports.setupAuthInstanceMock = setupAuthInstanceMock;
exports.setupClusterClientMock = setupClusterClientMock;
exports.setupConfigMock = setupConfigMock;
exports.setupContextMock = setupContextMock;
exports.setupDebugLogMock = setupDebugLogMock;
exports.setupFetchAllFromScrollMock = setupFetchAllFromScrollMock;
exports.setupHttpResponseMock = setupHttpResponseMock;
exports.setupHttpRouterMock = setupHttpRouterMock;
exports.setupHttpToolkitMock = setupHttpToolkitMock;
exports.setupKibanaCoreMock = setupKibanaCoreMock;
exports.setupLoggerMock = setupLoggerMock;
exports.setupPluginDependenciesMock = setupPluginDependenciesMock;
exports.setupSavedObjectsMock = setupSavedObjectsMock;
exports.setupSearchGuardBackendMock = setupSearchGuardBackendMock;
exports.setupSessionStorageFactoryMock = setupSessionStorageFactoryMock;
exports.setupTypeRegistryMock = setupTypeRegistryMock;
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* global jest */

function getCookieExpiryTimeMS(expireInDaysFromNow = 0) {
  const today = new Date();
  const expiryTime = new Date(today);
  expiryTime.setDate(expiryTime.getDate() + expireInDaysFromNow);
  return expiryTime.getTime();
}
function getCookieExpiryTimeS(...props) {
  return Math.floor(getCookieExpiryTimeMS(...props) / 1000);
}
function setupHttpRouterMock({
  ensureRawRequest = () => jest.fn()
} = {}) {
  return {
    ensureRawRequest
  };
}
function setupSearchGuardBackendMock({
  authinfo = jest.fn(),
  validateTenant = jest.fn(),
  validateRequestedTenant = jest.fn(),
  hasPermissions = jest.fn(),
  getTenantByPreference = jest.fn(),
  authenticateWithHeader = jest.fn(),
  authenticateWithHeaders = jest.fn(),
  getTenantInfoWithInternalUser = jest.fn(),
  getOIDCWellKnown = jest.fn(),
  getOIDCToken = jest.fn(),
  getUserTenantInfo = jest.fn(),
  convertUserTenantsToRecord = jest.fn(),
  removeNonExistingReadOnlyTenants = jest.fn()
} = {}) {
  return {
    authinfo,
    validateTenant,
    validateRequestedTenant,
    hasPermissions,
    getTenantByPreference,
    authenticateWithHeader,
    authenticateWithHeaders,
    getTenantInfoWithInternalUser,
    getOIDCWellKnown,
    getOIDCToken,
    getUserTenantInfo,
    convertUserTenantsToRecord,
    removeNonExistingReadOnlyTenants
  };
}
function setupKibanaCoreMock({
  basePath = '/abc',
  registerOnPreResponse = jest.fn(),
  getServerInfo = jest.fn()
} = {}) {
  return {
    http: {
      getServerInfo,
      basePath: {
        get: jest.fn(() => basePath)
      },
      registerOnPreResponse
    }
  };
}
function setupConfigMock({
  get = jest.fn()
} = {}) {
  return {
    get
  };
}
function setupLoggerMock({
  info = jest.fn(),
  error = jest.fn(),
  warn = jest.fn(),
  debug = jest.fn()
} = {}) {
  return {
    error,
    info,
    warn,
    debug
  };
}
function setupSessionStorageFactoryMock({
  asScoped = jest.fn()
} = {}) {
  return {
    asScoped
  };
}
function setupPluginDependenciesMock() {
  return jest.fn();
}
function setupTypeRegistryMock({
  getAllTypes = jest.fn().mockReturnValue([])
} = {}) {
  return {
    getAllTypes
  };
}
function setupSavedObjectsMock({
  getScopedClient = jest.fn(),
  createInternalRepository = jest.fn(),
  createScopedRepository = jest.fn(),
  createSerializer = jest.fn(),
  createExporter = jest.fn(),
  createImporter = jest.fn(),
  getTypeRegistry = setupTypeRegistryMock
} = {}) {
  return {
    getScopedClient,
    createInternalRepository,
    createScopedRepository,
    createSerializer,
    createExporter,
    createImporter,
    getTypeRegistry
  };
}
function setupHttpResponseMock({
  ok = jest.fn(),
  redirected = jest.fn(),
  unauthorized = jest.fn(),
  notFound = jest.fn(),
  internalError = jest.fn(),
  renderAnonymousCoreApp = jest.fn(),
  customError = jest.fn(),
  badRequest = jest.fn()
} = {}) {
  return {
    ok,
    redirected,
    unauthorized,
    notFound,
    internalError,
    renderAnonymousCoreApp,
    customError,
    badRequest
  };
}
function setupHttpToolkitMock({
  next = jest.fn(),
  notHandled = jest.fn(),
  authenticated = jest.fn()
} = {}) {
  return {
    next,
    notHandled,
    authenticated
  };
}
function setupAuthInstanceMock({
  getAllAuthHeaders = jest.fn(),
  handleAuthenticateWithHeaders = jest.fn(),
  handleAuthenticate = jest.fn(),
  clear = jest.fn()
} = {}) {
  return {
    getAllAuthHeaders,
    handleAuthenticateWithHeaders,
    handleAuthenticate,
    clear
  };
}
function setupContextMock() {
  return jest.fn();
}
function setupDebugLogMock() {
  return jest.fn();
}
function setupClusterClientMock({
  asCurrentUserTransportRequest = jest.fn(),
  asCurrentUserScroll = jest.fn(),
  asCurrentUserSearch = jest.fn(),
  asCurrentUserDelete = jest.fn(),
  asCurrentUserCatAliases = jest.fn(),
  asCurrentUserCatIndices = jest.fn(),
  asCurrentUserIndicesGetMapping = jest.fn()
} = {}) {
  return {
    asScoped: jest.fn(() => {
      return {
        asCurrentUser: {
          transport: {
            request: asCurrentUserTransportRequest
          },
          scroll: asCurrentUserScroll,
          search: asCurrentUserSearch,
          delete: asCurrentUserDelete,
          cat: {
            aliases: asCurrentUserCatAliases,
            indices: asCurrentUserCatIndices
          },
          indices: {
            getMapping: asCurrentUserIndicesGetMapping
          }
        }
      };
    })
  };
}
function setupFetchAllFromScrollMock(mockFn = jest.fn()) {
  return mockFn;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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